<?php

namespace App\Http\Controllers\Karyawan;

use App\Models\Gaji;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\DomPDF\Facade\Pdf;

class GajiController extends Controller
{
    public function index(Request $request)
    {
        $karyawanId = Auth::user()->karyawan->id;

        // Get filter values
        $tahun = $request->tahun;
        $bulan = $request->bulan;

        // Query builder
        $query = Gaji::where('karyawan_id', $karyawanId);

        // Apply filters
        if ($tahun) {
            $query->where('tahun', $tahun);
        }

        if ($bulan) {
            $query->where('bulan', $bulan);
        }

        // Get results
        $gaji = $query->orderByDesc('tahun')
                    ->orderByDesc('bulan')
                    ->get();

        return view('karyawan.gaji.index', compact('gaji', 'tahun', 'bulan'));
    }

    public function slip($id)
    {
        $karyawanId = Auth::user()->karyawan->id;

        $gaji = Gaji::where('id', $id)
            ->where('karyawan_id', $karyawanId)
            ->with(['karyawan.user', 'karyawan.jabatan'])
            ->firstOrFail();

        return view('karyawan.gaji.slip', compact('gaji'));
    }

    public function download($id)
    {
        $karyawanId = Auth::user()->karyawan->id;

        $gaji = Gaji::where('id', $id)
            ->where('karyawan_id', $karyawanId)
            ->with(['karyawan.user', 'karyawan.jabatan'])
            ->firstOrFail();

        $pdf = Pdf::loadView('karyawan.gaji.slip_pdf', compact('gaji'))
            ->setPaper('A4', 'portrait');

        return $pdf->download(
            'Slip-Gaji-' . $gaji->bulan . '-' . $gaji->tahun . '.pdf'
        );
    }
}
